'use strict';

/**
 * Neutrino API error codes
 */
class APIErrorCode
{    
	/**
	 * Get description of error code
	 */
    static getErrorMessage(errorCode) {
        switch (errorCode) {
            case APIErrorCode.INVALID_PARAMETER: return "MISSING OR INVALID PARAMETER";
            case APIErrorCode.MAX_CALL_LIMIT: return "DAILY API LIMIT EXCEEDED";
            case APIErrorCode.BAD_URL: return "INVALID URL";
            case APIErrorCode.ABUSE_DETECTED: return "ACCOUNT OR IP BANNED";
            case APIErrorCode.NOT_RESPONDING: return "NOT RESPONDING. RETRY IN 5 SECONDS";
            case APIErrorCode.CONCURRENT: return "TOO MANY CONNECTIONS";
            case APIErrorCode.NOT_VERIFIED: return "ACCOUNT NOT VERIFIED";
            case APIErrorCode.TELEPHONY_LIMIT: return "TELEPHONY NOT ENABLED ON YOUR ACCOUNT. PLEASE CONTACT SUPPORT FOR HELP";
            case APIErrorCode.INVALID_JSON: return "INVALID JSON. JSON CONTENT TYPE SET BUT NON-PARSABLE JSON SUPPLIED";
            case APIErrorCode.ACCESS_DENIED: return "ACCESS DENIED. PLEASE CONTACT SUPPORT FOR ACCESS TO THIS API";
            case APIErrorCode.MAX_PHONE_CALLS: return "MAXIMUM SIMULTANEOUS PHONE CALLS";
            case APIErrorCode.BAD_AUDIO: return "COULD NOT LOAD AUDIO FROM URL";
            case APIErrorCode.HLR_LIMIT_REACHED: return "HLR LIMIT REACHED. CARD DECLINED";
            case APIErrorCode.TELEPHONY_BLOCKED: return "CALLS AND SMS TO THIS NUMBER ARE LIMITED";
            case APIErrorCode.TELEPHONY_RATE_EXCEEDED: return "CALL IN PROGRESS";
            case APIErrorCode.FREE_LIMIT: return "FREE PLAN LIMIT EXCEEDED";
            case APIErrorCode.RENDERING_FAILED: return "RENDERING FAILED. COULD NOT GENERATE OUTPUT FILE";
            case APIErrorCode.DEPRECATED_API: return "THIS API IS DEPRECATED. PLEASE USE THE LATEST VERSION";
            case APIErrorCode.CREDIT_LIMIT_REACHED: return "ACCOUNT LIMITED. MAXIMUM USAGE CREDIT REACHED OR PAYMENT DECLINED";
            case APIErrorCode.NOT_MULTI_ENABLED: return "BATCH PROCESSING NOT ENABLED FOR THIS ENDPOINT";
            case APIErrorCode.NO_BATCH_MODE: return "BATCH PROCESSING NOT AVAILABLE ON YOUR PLAN";
            case APIErrorCode.BATCH_LIMIT_EXCEEDED: return "BATCH PROCESSING REQUEST LIMIT EXCEEDED";
            case APIErrorCode.BATCH_INVALID: return "INVALID BATCH REQUEST. DOES NOT CONFORM TO SPEC";
            case APIErrorCode.DATASET_UNKNOWN: return "UNKNOWN DATASET ID OR INVALID DATASET OPTION SUPPLIED";
            case APIErrorCode.DATASET_GENERATION_FAILED: return "FAILED TO GENERATE DATASET OUTPUT FILE";
            case APIErrorCode.DATASET_INVALID_DATE: return "INVALID DATE SUPPLIED OR DATE IS BEFORE FIRST HISTORICAL RECORD";
            case APIErrorCode.USER_DEFINED_DAILY_LIMIT: return "DAILY API LIMIT EXCEEDED. SET BY ACCOUNT HOLDER";
            case APIErrorCode.ACCESS_FORBIDDEN: return "ACCESS DENIED. USER ID OR API KEY INVALID";
            case APIErrorCode.REQUEST_TOO_LARGE: return "REQUEST TOO LARGE. MAXIMUM SIZE IS 5MB FOR DATA AND 25MB FOR UPLOADS";
            case APIErrorCode.NO_ENDPOINT: return "ENDPOINT DOES NOT EXIST";
            case APIErrorCode.INTERNAL_SERVER_ERROR: return "FATAL EXCEPTION. REQUEST COULD NOT BE COMPLETED";
            case APIErrorCode.SERVER_OFFLINE: return "SERVER OFFLINE. MAINTENANCE IN PROGRESS";
            case APIErrorCode.CONNECT_TIMEOUT: return "TIMEOUT OCCURRED CONNECTING TO SERVER";
            case APIErrorCode.READ_TIMEOUT: return "TIMEOUT OCCURRED READING API RESPONSE";
            case APIErrorCode.TIMEOUT: return "TIMEOUT OCCURRED DURING API REQUEST";
            case APIErrorCode.DNS_LOOKUP_FAILED: return "ERROR RECEIVED FROM YOUR DNS RESOLVER";
            case APIErrorCode.TLS_PROTOCOL_ERROR: return "ERROR DURING TLS PROTOCOL HANDSHAKE";
            case APIErrorCode.URL_PARSING_ERROR: return "ERROR PARSING REQUEST URL";
            case APIErrorCode.NETWORK_IO_ERROR: return "IO ERROR DURING API REQUEST";
            case APIErrorCode.FILE_IO_ERROR: return "IO ERROR WRITING TO OUTPUT FILE";
            case APIErrorCode.INVALID_JSON_RESPONSE: return "INVALID JSON DATA RECEIVED";
            case APIErrorCode.NO_DATA: return "NO PAYLOAD DATA RECEIVED";
            case APIErrorCode.API_GATEWAY_ERROR: return "API GATEWAY ERROR";
            default: return `API Error: return ${errorCode}`;
        }
    }
}
APIErrorCode.INVALID_PARAMETER = 1
APIErrorCode.MAX_CALL_LIMIT = 2
APIErrorCode.BAD_URL = 3
APIErrorCode.ABUSE_DETECTED = 4
APIErrorCode.NOT_RESPONDING = 5
APIErrorCode.CONCURRENT = 6
APIErrorCode.NOT_VERIFIED = 7
APIErrorCode.TELEPHONY_LIMIT = 8
APIErrorCode.INVALID_JSON = 9
APIErrorCode.ACCESS_DENIED = 10
APIErrorCode.MAX_PHONE_CALLS = 11
APIErrorCode.BAD_AUDIO = 12
APIErrorCode.HLR_LIMIT_REACHED = 13
APIErrorCode.TELEPHONY_BLOCKED = 14
APIErrorCode.TELEPHONY_RATE_EXCEEDED = 15
APIErrorCode.FREE_LIMIT = 16
APIErrorCode.RENDERING_FAILED = 17
APIErrorCode.DEPRECATED_API = 18
APIErrorCode.CREDIT_LIMIT_REACHED = 19
APIErrorCode.NOT_MULTI_ENABLED = 21
APIErrorCode.NO_BATCH_MODE = 22
APIErrorCode.BATCH_LIMIT_EXCEEDED = 23
APIErrorCode.BATCH_INVALID = 24
APIErrorCode.DATASET_UNKNOWN = 26
APIErrorCode.DATASET_GENERATION_FAILED = 27
APIErrorCode.DATASET_INVALID_DATE = 28
APIErrorCode.USER_DEFINED_DAILY_LIMIT = 31
APIErrorCode.ACCESS_FORBIDDEN = 43
APIErrorCode.REQUEST_TOO_LARGE = 44
APIErrorCode.NO_ENDPOINT = 45
APIErrorCode.INTERNAL_SERVER_ERROR = 51
APIErrorCode.SERVER_OFFLINE = 52
APIErrorCode.CONNECT_TIMEOUT = 61
APIErrorCode.READ_TIMEOUT = 62
APIErrorCode.TIMEOUT = 63
APIErrorCode.DNS_LOOKUP_FAILED = 64
APIErrorCode.TLS_PROTOCOL_ERROR = 65
APIErrorCode.URL_PARSING_ERROR = 66
APIErrorCode.NETWORK_IO_ERROR = 67
APIErrorCode.FILE_IO_ERROR = 68
APIErrorCode.INVALID_JSON_RESPONSE = 69
APIErrorCode.NO_DATA = 70
APIErrorCode.API_GATEWAY_ERROR = 71

module.exports = APIErrorCode;